% 
% Create Example 6-2 in the book
%
% Dongrui Wu (dongruiw@usc.edu), 7/29/2009

clc
clear all
close all
warning off all

%% get the FOUs from the IA
[words,MFs,Cs]=getFOUsC6();
subset9=[1 7 10 12 14 18 21 26 32];

%% Construct the rulebase
subsetSurvey=[14 26]; %% indices of the two words used in the survey
inputWords=[18 21];
fullHistogram=[38 7 2 0 0
    33 11 3 0 0
    6 21 16 4 0
    0 12 28 8 1
    0 9 16 19 3
    31 11 4 1 0
    17 23 7 0 0
    0 19 19 8 1
    1 8 23 13 2
    0 7 17 21 2
    7 23 16 1 0
    5 22 20 0 0
    2 7 22 15 1
    1 4 13 17 12
    0 4 12 24 7
    7 13 21 6 0
    3 11 23 10 0
    0 3 18 18 8
    0 1 9 17 20
    1 2 6 11 27
    2 16 18 11 0
    2 9 22 13 1
    0 3 15 18 11
    0 1 7 17 22
    0 2 3 12 30]; %% survey histrogram
histogram=fullHistogram([13 14 18 19],:);

antMFsSurvey=MFs(subsetSurvey,:);
CsSurvey=Cs(subsetSurvey); %% centers of centroid of the five words in the survey

%% Plot the 9 ordered IT2 FS word models in a single figure ----
figure
set(gcf,'DefaulttextFontName','times new roman');
set(gcf,'DefaultaxesFontName','times new roman');
set(gcf,'DefaulttextFontAngle','italic');
set(gcf,'DefaulttextFontSize',12);
set(gcf,'DefaultaxesFontSize',10);
set(gcf,'DefaultlineLineWidth',1.2);
set(gcf,'DefaultaxesLineWidth',.35);
for i=1:9
    subplot(5,3,i);
    fill(MFs(subset9(i),[1:4 8 7 6 5 1]),[0 1 1 0 0 MFs(subset9(i),[9 9]) 0 0],[0.9 0.9 0.9]);
    hold on;
    plot(MFs(subset9(i),1:4),[0 1 1 0],'k');
    plot(MFs(subset9(i),5:8),[0 MFs(subset9(i),[9 9]) 0],'k');
    position=find(words(subset9(i),1:floor(size(words,2)/2))~=' ',1,'first');
    words2=[words(subset9(i),1:position-1) num2str(i) '.  ' words(subset9(i),position:end)];
    title(words2,'fontsize',12);
    set(gca,'YTick',[]);
    set(gca,'XTick',[]);
    axis([0 10 0 1]);
end
saveas(gcf,'Fig6-8.eps');

%% Compute the consequent FOUs and plot
numbers='abcd';
conMFs=zeros(size(histogram,1),9);
for k=1:4
    figure
    set(gcf,'DefaulttextFontName','times new roman');
    set(gcf,'DefaultaxesFontName','times new roman');
    set(gcf,'DefaulttextFontAngle','italic');
    set(gcf,'DefaulttextFontSize',10);
    set(gcf,'DefaultaxesFontSize',10);
    set(gcf,'DefaultlineLineWidth',1.2);
    set(gcf,'DefaultaxesLineWidth',.35);
    subplot(5,2.5,1);
    [YU,UU,YL,UL]=lwaPR(MFs([1  12 14 26 32],:),[histogram(k,:)' histogram(k,:)'],2);
    conMFs(k,:)=[YU YL max(UL)];
    fill([YU YL(length(YL):-1:1)],[UU UL(length(UL):-1:1)],[0.9 0.9 0.9]);
    hold on;
    plot([YU YL(length(UL):-1:1)],[UU UL(length(UL):-1:1)],'w');
    [YU,UU,YL,UL]=lwaPR(MFs([1  12 14 26 32],:),[histogram(k,:)' histogram(k,:)'],2);
    plot([YU YL(length(UL):-1:1)],[UU UL(length(UL):-1:1)],'k-');
    plot([0 YU(2)],[1 1],'k:','linewidth',1);
    text('Interpreter','latex','String',['$\widetilde{Y}^' num2str(k) '$'],...
        'Position',[mean(YU(2:3)),1.03],'horizontalalignment','center',...
        'verticalalignment','bottom');
    set(gca,'YTick',[0 1]);
    axis([0 10 0 1.3]);
    saveas(gcf,['Fig6-11' numbers(k) '.eps']);
end

%% PR using firing levels
%% compute the output FOUs
conMFsC=zeros(size(words,1),9);
for i=1:length(subsetSurvey)
    for j=1:length(subsetSurvey)
        antMFsSurvey((i-1)*2+j,1:18)=[MFs(subsetSurvey(i),:) MFs(subsetSurvey(j),:)];
    end
end
k=0;
for i=inputWords
    for j=inputWords
        k=k+1;
        [YU,UU,YL,UL]=PR([MFs(i,:) MFs(j,:)],antMFsSurvey,conMFs);
        conMFsC(k,:)=[YU YL max(UL)];
    end
end

%% plot the consequent MFs
k=0;
sim=zeros(1,9);
for i=inputWords
    for j=inputWords
        k=k+1;
        figure
        set(gcf,'DefaulttextFontName','times new roman');
        set(gcf,'DefaultaxesFontName','times new roman');
        set(gcf,'DefaulttextFontAngle','italic');
        set(gcf,'DefaulttextFontSize',10);
        set(gcf,'DefaultaxesFontSize',10);
        set(gcf,'DefaultlineLineWidth',1.2);
        set(gcf,'DefaultaxesLineWidth',.35);
        subplot(5,2.5,1);
        fill(conMFsC(k,[1:4 8 7 6 5 1]),[0 1 1 0 0 conMFsC(k,9) conMFsC(k,9) 0 0],[1 1 1]);
        hold on;
        plot(conMFsC(k,[1:4 8:-1:5]),[0 1 1 0 0 conMFsC(k,[9 9]) 0],'w');
        for t=1:9
            sim(t)=Jaccard(conMFsC(k,:),MFs(subset9(t),:));
        end
        [temp,index]=max(sim);
        index=subset9(index);
        fill(MFs(index,[1:4 8 7 6 5 1]),[0 1 1 0 0 MFs(index,[9 9]) 0 0],[1 1 1]);
        plot(conMFsC(k,[1:4 8:-1:5]),[0 1 1 0 0 conMFsC(k,[9 9]) 0],'k--');
        plot(MFs(index,[1:4 8:-1:5]),[0 1 1 0 0 MFs(index,[9 9]) 0],'k');
        plot([0 conMFsC(k,2)],[1 1],'k:','linewidth',1);
        text(mean(MFs(index,2:3))-1.1, 1.02, words(index,:),'HorizontalAlignment','Center',...
            'verticalalignment','bottom');
        set(gca,'YTick',[0 1]);
        axis([0 10 0 1.3]);
        saveas(gcf,['Fig6-12' numbers(k) '.eps']);
    end
end


